/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.replace;

import com.ibm.hsc.auiml.databeans.sfp.replace.ReplaceEnclosureBean;
import com.ibm.hsc.auiml.databeans.sfp.replace.ReplaceHardwareConstants;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.ccfw.mom.PIFrame;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PILEDDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.ReplacePartsTarget;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfig;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.tasklet.ServiceActionDriverTasklet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ReplaceEnclosureTasklet
extends TargetedTasklet
implements ReplaceHardwareConstants {
    private static final String TRACE_MASKD = "JRPENTKD";
    private static final String TRACE_MASKF = "JRPENTKF";
    private static final String TRACE_MASKT = "JRPENTKT";
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.replace.ReplaceHardware";
    private static final String INITIAL_PANEL = "ReplaceEnclosure";
    private static final String RV_TASKLET = "com.ibm.hwmca.xfw.service.tasklet.RepairAndVerifyTasklet";
    private static final LocalizableText BUSY_TITLE = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_ENCLOSURE_TITLE");
    private static final LocalizableText BUSY_CONTENT = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_ENCLOSURE_TEXT");
    private static final String ENCL = "encl";
    private static final String SYS_TAG = "sys";
    public static final String UNSUPPORTED_ENCLOSURE = "unsupported_enclosure";
    private static final short ERRID_0000 = 0;
    private static final short ERRID_0001 = 1;
    private static final short ERRID_0002 = 2;
    private static final short ERRID_0003 = 3;
    private static final short ERRID_0004 = 4;
    private String userDefinedName = null;
    private String bpaType = null;
    private String bpaModel = null;
    private String bpaSerial = null;
    private String bpaMtms = null;
    private PIHSCCECClient r5Client = null;
    private PIHSCFrameClient r5fClient = null;
    private boolean TargetIsACec;
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -125, "SFPRepEncl");

    public ReplaceEnclosureTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> ReplaceEnclosureTasklet c-tor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.service()");
        if (panelTaskletRequest.isInitialRequest()) {
            Trace.trace((String)TRACE_MASKF, (Object)"-> ReplaceEnclosureTasklet.isInitialRequest()");
            ReplaceEnclosureBean replaceEnclosureBean = new ReplaceEnclosureBean();
            replaceEnclosureBean.setBeanName("ReplaceEnclosureBean");
            Target[] targetArray = this.getSelectedTargets();
            String string = targetArray[0].getName().toString();
            Object object = ((ReplacePartsTarget)targetArray[0]).getTargetObject();
            if (object instanceof PICec || object instanceof PIFrame) {
                if (object instanceof PICec) {
                    this.userDefinedName = ((PICec)object).getUserDefinedName();
                    this.TargetIsACec = true;
                    Trace.trace((String)TRACE_MASKF, (Object)"-- target selected is a CEC");
                } else {
                    this.userDefinedName = ((PIFrame)object).getName();
                    this.bpaType = ((PIFrame)object).getMachineType();
                    this.bpaModel = ((PIFrame)object).getModel();
                    this.bpaSerial = ((PIFrame)object).getSerialNumber();
                    this.bpaMtms = this.bpaType + "." + this.bpaModel + "." + this.bpaSerial;
                    this.TargetIsACec = false;
                    Trace.trace((String)TRACE_MASKF, (Object)"-- target selected is a Frame");
                }
                Trace.trace((String)TRACE_MASKF, (Object)("-- selected system is: " + string + ", user defined name is: " + this.userDefinedName));
                if (string != null && string.length() != 0) {
                    replaceEnclosureBean.setSelectedSystem(string);
                }
                try {
                    this.showBusyDialog(BUSY_TITLE, BUSY_CONTENT);
                    this.getAllEnclosureInfo(replaceEnclosureBean, this.userDefinedName);
                    ArrayList arrayList = replaceEnclosureBean.getInstalledEnclosureLocCodes();
                    if (arrayList != null && arrayList.size() > 0) {
                        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                        String[] stringArray2 = this.getListOfEnclosureTypes(stringArray, replaceEnclosureBean);
                        if (stringArray2 != null) {
                            for (int i = 0; i < stringArray2.length; ++i) {
                                Trace.trace((String)TRACE_MASKF, (Object)("enclosure type returned: " + stringArray2[i]));
                            }
                        }
                        if (stringArray2 != null) {
                            replaceEnclosureBean.setInstalledEnclosureTypes(stringArray2);
                        }
                    }
                    panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)replaceEnclosureBean);
                    this.destroyBusyDialog();
                }
                catch (Exception exception) {
                    String string2;
                    Trace.trace((String)TRACE_MASKF, (Object)("-- exception during initial service request, e is " + exception));
                    this.destroyBusyDialog();
                    new AusMicrocodeLog(_logInfo, 1, exception).writeEntry(null);
                    if (exception.getMessage().equals("CIMNullClient")) {
                        string2 = "0242";
                    } else if (exception.getMessage().equals("CIMBadClient")) {
                        string2 = "0243";
                    } else if (exception instanceof UnknownHostException) {
                        string2 = "0241";
                    } else if (exception instanceof PIHscClientException) {
                        String string3 = ((PIHscClientException)exception).getMsgId();
                        Trace.trace((String)TRACE_MASKF, (Object)("-- PIHscClientException msg ID is " + string3));
                        string2 = "0238";
                    } else {
                        string2 = "0245";
                    }
                    SFPUtil.showSFPErrorMessageBox(string2, (PanelTasklet)this);
                    try {
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)replaceEnclosureBean);
                    }
                    catch (Exception exception2) {
                        Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during initial service request, e1 is " + exception2));
                        panelTaskletResponse.terminate();
                    }
                }
            } else {
                panelTaskletResponse.noAction();
            }
            Trace.trace((String)TRACE_MASKF, (Object)"<- ReplaceEnclosureTasklet.isInitialRequest()");
        } else if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
            Trace.trace((String)TRACE_MASKF, (Object)"taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
            panelTaskletResponse.dispose();
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"Some taskletRequest other than Cancel is pending.");
            String string = (String)panelTaskletRequest.getData("Command");
            ReplaceEnclosureBean replaceEnclosureBean = (ReplaceEnclosureBean)panelTaskletRequest.getData("DataBean");
            if (string.equals("")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
                panelTaskletResponse.noAction();
            } else if (string.equals("CommitButton")) {
                this.launchRepair(panelTaskletResponse, replaceEnclosureBean);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Unknown tasklet request sent to ReplaceEnclosureTasklet.");
                panelTaskletResponse.noAction();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.service()");
    }

    public void getAllEnclosureInfo(ReplaceEnclosureBean replaceEnclosureBean, String string) throws Exception {
        block11: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.getAllEnclosureInfo()");
            try {
                if (this.r5Client == null || this.r5fClient == null) {
                    if (this.TargetIsACec) {
                        this.r5Client = this.createCECClient(string);
                    } else {
                        this.r5fClient = this.createFrameClient(string);
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)"-- CIM client value should now be set");
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- CIM client instance has already been set");
                }
                if (this.r5Client != null || this.r5fClient != null) {
                    try {
                        if (this.TargetIsACec) {
                            this.getInstalledEnclosureInfo(this.r5Client, replaceEnclosureBean);
                        } else {
                            this.getAllFrameSysInfo(this.r5fClient, replaceEnclosureBean);
                        }
                        Trace.trace((String)TRACE_MASKD, (Object)"-- getInstalledEnclosureInfo()/getAllFrameSysInfo() completed successfully");
                        break block11;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught during getInstalledEnclosureInfo()/getAllFrameSysInfo(), exception is: " + exception));
                        Trace.trace((String)TRACE_MASKF, (Object)exception);
                        new AusMicrocodeLog(_logInfo, 2, exception).writeEntry(null);
                        throw exception;
                    }
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- CIM client creation returned null");
                new AusMicrocodeLog(_logInfo, 3).writeEntry(null);
                throw new Exception("CIMNullClient");
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, rethrowing..." + exception));
                new AusMicrocodeLog(_logInfo, 4, exception).writeEntry(null);
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.getAllEnclosureInfo()");
    }

    private PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.createCECClient()");
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKD, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, false);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw new Exception("CIMBadClient");
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    private PIHSCFrameClient createFrameClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.createFrameClient()");
        PIHSCFrameClient pIHSCFrameClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                Trace.trace((String)TRACE_MASKD, (Object)("-- selected system name is: " + string));
                pIHSCFrameClient = pIHSCClientObjectFactory.createFrameClient(string, false);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5fClient is: " + exception));
                throw new Exception("CIMBadClient");
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.createCECClient()");
        return pIHSCFrameClient;
    }

    protected void getInstalledEnclosureInfo(PIHSCCECClient pIHSCCECClient, ReplaceEnclosureBean replaceEnclosureBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.getInstalledEnclosureInfo()");
        PILEDDataBean pILEDDataBean = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            pILEDDataBean = pIHSCCECClient.getEnclosureLEDInfo();
            String[] stringArray = pILEDDataBean.getLocationCodes();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                    Trace.trace((String)TRACE_MASKF, (Object)("--locCode is <" + stringArray[i] + ">"));
                    String string = this.convertLocCodeToMtms(stringArray[i]);
                    arrayList2.add(string);
                }
                Trace.trace((String)TRACE_MASKF, (Object)("-- system contains " + stringArray.length + " enclosures"));
                replaceEnclosureBean.setInstalledEnclosureLocCodes(arrayList);
                replaceEnclosureBean.setInstalledEnclosureMTMS(arrayList2);
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"-- getLocationCodes() call returned null");
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getEnclosureLEDInfo() cmd. Exception is: " + exception));
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.getInstalledEnclosureInfo()");
    }

    private void getAllFrameSysInfo(PIHSCFrameClient pIHSCFrameClient, ReplaceEnclosureBean replaceEnclosureBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.getAllFrameSysInfo()");
        PILEDDataBean pILEDDataBean = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Vector vector = null;
        try {
            int n;
            String string;
            String[] stringArray;
            String string2 = replaceEnclosureBean.getSelectedSystem();
            String string3 = string2.substring(0, 4);
            String string4 = string2.substring(5, 8);
            vector = pIHSCFrameClient.getAllLocationCodes();
            if (vector != null && vector.size() > 0) {
                int n2;
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    pILEDDataBean = (PILEDDataBean)vector.elementAt(n2);
                    stringArray = pILEDDataBean.getEnclosures();
                    String[] stringArray2 = pILEDDataBean.getLocationCodes();
                    string = null;
                    for (n = 0; n < stringArray.length; ++n) {
                        if (stringArray[n].equals(ENCL)) {
                            string = stringArray2[n].substring(1, 5);
                            if (string.equals(string3)) {
                                Trace.trace((String)TRACE_MASKF, (Object)("-- system returned as an enclosure detected at index: " + n));
                            }
                            Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure detected : <" + stringArray2[n] + ">"));
                            arrayList.add(stringArray2[n]);
                            continue;
                        }
                        if (stringArray[n].equals(SYS_TAG)) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- found the system identifier marker at index: " + n + ", bypassing..."));
                            continue;
                        }
                        Trace.trace((String)TRACE_MASKF, (Object)("-- found a Fru at index <" + n + ">, loc code is<" + stringArray2[n] + ">, bypassing..."));
                    }
                }
                if (arrayList.size() > 0) {
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        string2 = this.convertLocCodeToMtms((String)arrayList.get(n2));
                        arrayList2.add(string2);
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("-- system contains " + arrayList.size() + " enclosures"));
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- getLocationCodes() call returned null");
                }
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"-- no PILEDDataBeans returned from getAllLocationCodes() call.");
            }
            Object var10_12 = null;
            stringArray = "U" + this.bpaMtms;
            boolean bl = true;
            string = null;
            for (n = 0; n < arrayList.size(); ++n) {
                if (!stringArray.equals((String)arrayList.get(n))) continue;
                bl = false;
                break;
            }
            Trace.trace((String)TRACE_MASKF, (Object)("-- addBPA status is <" + bl + ">"));
            if (bl) {
                arrayList.add(stringArray);
                string2 = this.convertLocCodeToMtms((String)stringArray);
                arrayList2.add(string2);
            }
            replaceEnclosureBean.setInstalledEnclosureLocCodes(arrayList);
            replaceEnclosureBean.setInstalledEnclosureMTMS(arrayList2);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getAllHardwareInfo() cmd. Exception is: " + exception));
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.getAllFrameSysInfo()");
    }

    private String convertLocCodeToMtms(String string) {
        String string2 = null;
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.convertLocCodeToMtms()");
        Trace.trace((String)TRACE_MASKF, (Object)("-- input location code is: <" + string + ">"));
        try {
            String string3 = string.substring(1, 17);
            String string4 = string3.substring(0, 4);
            String string5 = string3.substring(5, 8);
            String string6 = string3.substring(9);
            Trace.trace((String)TRACE_MASKF, (Object)("-- type/model/sn is <" + string4 + "/" + string5 + "/" + string6 + ">"));
            string2 = string4 + "-" + string5 + "/" + string6;
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("exception caught during convertLocCodeToMtms, e is: " + exception));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.convertLocCodeToMtms()");
        return string2;
    }

    private String[] getListOfEnclosureTypes(String[] stringArray, ReplaceEnclosureBean replaceEnclosureBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.determineListOfEnclosureTypes()");
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosureLocCodes (String[]) array size is: " + n));
        String string = replaceEnclosureBean.getSelectedSystem();
        String string2 = string.substring(0, 4);
        String string3 = string.substring(5, 8);
        for (int i = 0; i < n; ++i) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosure location code[" + i + "] is <" + stringArray[i] + ">"));
        }
        Trace.trace((String)TRACE_MASKF, (Object)("-- input system type/model is " + string2 + "/" + string3));
        if (n > 0) {
            try {
                FruConfig fruConfig = new FruConfig(string2, string3);
                stringArray2 = fruConfig.queryDescriptionsByLocation(stringArray, null);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is <" + exception + ">"));
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.determineListOfEnclosureTypes()");
        return stringArray2;
    }

    private void launchRepair(PanelTaskletResponse panelTaskletResponse, ReplaceEnclosureBean replaceEnclosureBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.launchRepair()");
        String string = replaceEnclosureBean.getSelectedSystem();
        Trace.trace((String)TRACE_MASKF, (Object)("-- input mtms data for R/V call is : " + string));
        ArrayList arrayList = replaceEnclosureBean.getPendingEnclosureLocCodes();
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)arrayList.get(i);
                Trace.trace((String)TRACE_MASKF, (Object)("-- input locCode data for R/V call is : " + stringArray[i]));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("rvType", "REPLACE_ENCLOSURE");
            hashMap.put("SYSTEM_MTMS", string);
            hashMap.put("LOCATIONS", stringArray);
            Trace.trace((String)TRACE_MASKF, (Object)"RemoveFRUTasklet.launchRepair() now redirecting tasklet control...");
            try {
                ServiceActionDriverTasklet.taskletBugMap = hashMap;
                panelTaskletResponse.redirect(RV_TASKLET, hashMap);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception while launching redirect dialog, e is " + exception));
            }
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"-- pending enclosure locCode array is null");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- RepalceEnclosureTasklet.launchRepair()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ReplaceEnclosureTasklet.logException()");
        Trace.trace((String)TRACE_MASKF, (Object)("processing exception: " + throwable));
        HException hException = new HException(throwable);
        new AusMicrocodeLog(_logInfo, 0, hException).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<- ReplaceEnclosureTasklet.logException()");
    }
}

